//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
//******************************************

//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#include "iApp.h"
#include "OPmode.h"
#include "KWU.h"

//-- header guards --//


//-- function definition --//




void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//


//	disable all Key-On Wakeup setting
	d_KWU_all_disable;				//	disable all Key-On Wakeup setting

//	Key-On Wakeup setting
	d_KWU_03_EnL;
//......|..| EnL/EnH/Dis: STOP mode release level, or Disable
//......| 00~15: KWU00~KWU15

	delay_times(t_1ms, 1);			// when using the built-in pull-up or pull-down resistors, wait for 10us before entering STOP mode
	__asm("CPL (_P9DR).0");
	Active_STOP;					// enter STOP mode
	__asm("CPL (_P9DR).0");
//	d_KWU_02_Dis;					// disable Key-On Wakeup setting


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


